﻿using Ozeki.VoIP;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WhatsAppPBX
{
    internal class MyDialplanProvider : IDialplanProvider
    {
        public string Name => "MyDialplanProvider";

        readonly IExtensionContainer _extensionContainer;

        public MyDialplanProvider(IExtensionContainer extensionContainer)
        {
            _extensionContainer = extensionContainer;
        }

        public IDialplanResult GetDestination(RouteInfo routeInfo)
        {
            // Hangup call if busy or unanswered
            if (routeInfo.State != RoutingState.Calling)
                return null;

            var currentDialed = routeInfo.DialInfo.Dialed;
            if (currentDialed == MyPBX.BusinessPhoneNumber)
            {
                // User-initiated call: route business number to extension
                var extension = _extensionContainer.GetExtension(MyPBX.ExtensionId);
                if (extension == null)
                    return null;
                return new Destination(extension.ExtensionID);
            }

            if (currentDialed.StartsWith(MyPBX.VoIPServiceOutboundPrefix))
            {
                // Business-initiated call: prefix indicates outbound via VoIP provider
                var destination = new Destination(MyPBX.VoIPServiceConnectionID);
                destination.DialInfo = new DialInfo(currentDialed);
                return destination;
            }

            // Default: call the dialed number
            return new Destination(currentDialed);
        }

        public SessionMode GetSessionMode(IBaseCall caller, IBaseCall callee, SessionMode defaultSessionMode)
        {
            return defaultSessionMode;
        }
    }
}
